﻿using System;
using System.IO;
using Microsoft.SharePoint;

namespace UploadFile
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               // Hole eine Referenz auf die Dokumentenbibliothek
               SPList listDocs = web.Lists.TryGetList("Dokumente");

               // Hole die Quelldatei
               FileInfo fileInfo = new FileInfo(@"C:\temp.txt");

               byte[] buffer = new byte[fileInfo.Length];

               // Lese die Datei von der Festplatte
               using (FileStream stream = new FileStream(
                  fileInfo.FullName,
                  FileMode.Open))
               {
                  stream.Read(buffer, 0, buffer.Length);
               }

               // Speicher die Datei im Root Folder ab
               SPFile newFile = listDocs.RootFolder.Files.Add(
                  fileInfo.Name,    // Dateiname
                  buffer,           // Byte Array
                  true);            // Überschreiben

               Console.WriteLine("Datei hochgeladen: {0} ({1})",
                  newFile.Name,
                  newFile.TimeCreated);
            }
         }
      }
   }
}